NAVCollectionCursor.prototype.close = function () {
    this.forwardToCustomFunction("collectionCursorClose");
};

NAVCollectionCursor.prototype.forEach = function (func) {
    while (this.hasNext())
        func(this.next());
};

NAVCollectionCursor.prototype.hasNext = function () {
    return this.forwardToCustomFunction("collectionCursorHasNext");
};

NAVCollectionCursor.prototype.help = function () {
    print("\nCursor methods\n" +
        "\t.toArray() - iterates through docs and returns an array of the results\n" +
        "\t.forEach( func )\n" +
        "\t.map( func )\n" +
        "\t.hasNext()\n" +
        "\t.next()\n" +
        "\t.objsLeftInBatch() - returns count of docs left in current batch(when exhausted, a new getMore will be issued)\n" +
        "\t.itcount() - iterates through documents and counts them\n" +
        "\t.pretty() - pretty print each document, possibly over multiple lines\n" +
        "\t.close()\n");
};

NAVCollectionCursor.prototype.isClosed = function () {
    return this.forwardToCustomFunction("collectionCursorIsClosed");
};

NAVCollectionCursor.prototype.isExhausted = function () {
    return this.forwardToCustomFunction("collectionCursorIsExhausted");
};

NAVCollectionCursor.prototype.itcount = function () {
    return this.forwardToCustomFunction("collectionCursorItcount");
};

NAVCollectionCursor.prototype.map = function (jsFunction) {
    var array = [];
    while (this.hasNext())
        array.push(jsFunction(this.next()));
    return array;
};

NAVCollectionCursor.prototype.next = function () {
    return this.forwardToCustomFunction("collectionCursorNext");
};

NAVCollectionCursor.prototype.objsLeftInBatch = function () {
    return this.forwardToCustomFunction("collectionCursorObjsLeftInBatch");
};

NAVCollectionCursor.prototype.pretty = function () {
    return this;
};

NAVCollectionCursor.prototype.toArray = function () {
    if (this._array)
        return this._array;

    var newArray = [];
    while (this.hasNext())
        newArray.push(this.next());
    this._array = newArray;
    return newArray;
}
